# Veteran Appointment Request Service

## Summary

Veteran Appointment Request Service provides RESTful web services that allow a client to schedule and view veteran appointments.

## Description
This API will allow for a client to interact with VistA scheduling and viewing veteran appointments when running in a local nextgen dev environment.

## Use
### Direct Scheduling

This REST service is used to get resource directory for direct scheduling.

    GET
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/directscheduling-resource-directory

This REST service is used to fetch all the appointment slots for selected facility from vista via scheduling manager for logged in patient/veteran

    GET
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/site/{site-code}/patient/{assigning-authority}/{patient-id}/available-appointment-slots

This REST service is used to update the booked appointment status to cancel in selected facility in vista via scheduling manager for logged in patient/veteran

    PUT
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/site/{site-code}/patient/{assigning-authority}/{patient-id}/cancel-appointment

This REST service is used to save appointment for selected facility in vista via scheduling manager for logged in patient/veteran

    POST
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/site/{site-code}/patient/{assigning-authority}/{patient-id}/booked-appointments

This REST service is used to fetch cancel reason list for selected facility from vista via scheduling manager for logged in patient/veteran

    GET
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/site/{site-code}/patient/{assigning-authority}/{patient-id}/cancel-reasons-list

This REST service is used to fetch all booked appointments for selected facility from vista via scheduling manager for logged in patient/veteran.

    GET
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/site/{site-code}/patient/{assigning-authority}/{patient-id}/booked-appointments

This REST service is used to logout MDWS session open for selected facility for logged in patient/veteran

    GET
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/site/{site-code}/logout

This REST service sends email confirmation after appointment is booked

    PUT
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/booking-confirmation

This REST service sends email confirmation after appointment is cancelled

    PUT
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/cancel-confirmation

This REST service is used to fetch PACT relationship with facilities, providers and clinics associated for logged in patient/veteran

    GET
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/patient/{assigning-authority}/{patient-id}/facility-provider


    GET
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/patient/{assigning-authority}/{patient-id}/facility-provider-view


    GET
    http://host:port/VeteranAppointmentRequestService/v4/direct-scheduling/patient/{assigning-authority}/{patient-id}/facility-provider-all



### Appointment Request
This REST service provides resource directory to front-end

    GET
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/var-patient-resource-directory

This REST service is used to capture/save the metric if icn or dfn for a patient is not found

    POST
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/metrics/no-icn-or-dfn

This REST service is used to capture/save the metric if a patient is not registered to any facility

    POST
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/metrics/no-dfn-cancel-request

This REST service is used to fetch detail codes from SED database

    GET
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/metadata

A resource that returns all {@link VARAppointmentRequests} that have been created by this user.

    GET
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointments

A resource that returns all {@link VARAppointmentRequestMessages} that have been created by this user.

    GET
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointment-requests/system/{system-id}/id/{appointment-request-id}/messages

This REST service is used to save a message for select appointment request

    POST
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointment-requests/system/{system-id}/id/{appointment-request-id}/messages

This REST service is used to save/update the flag that message from provider is been read by veteran

    POST
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointment-requests/system/{system-id}/id/{appointment-request-id}/messages/read

A resource that returns a single {@link VARAppointmentRequest} by user and id

    GET
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointments/system/{system-id}/id/{appointment-request-id}

A resource that saves a single {@link VARAppointmentRequest} by user and id

    PUT
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointments/system/{system-id}/id/{appointment-request-id}

A resource that allows a client to save an {@link VARAppointmentRequest}.

    POST
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointments

This REST service is used to save the state of appointment request thats under process of being booked by a provider so that other provider cannot update the appointment request

    POST
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointments/system/{system-id}/id/{appointment-request-id}/inprocess

This REST service is to used to delete the state of the appointment requests thats processed/booked by a provider

    DELETE
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/patient/{assigning-authority}/{patient-id}/appointments/system/{system-id}/id/{appointment-request-id}/inprocess

This REST service is used to save feedback from the user

    POST
    http://host:port/VeteranAppointmentRequestService/v4/appointment-service/feedback



### Facility
Retrieves the CDW Facilities

    GET
    http://host:port/VeteranAppointmentRequestService/v4/facility-service/

### Patient Preferences
This REST service is used to fetch patient preferences from SED database

    GET
    http://host:port/VeteranAppointmentRequestService/v4/patient/{assigning-authority}/{patient-id}/preference

This REST service is used to save/update patient preferences into SED database

    POST
    http://host:port/VeteranAppointmentRequestService/v4/patient/{assigning-authority}/{patient-id}/preference

### Provider
Returns all primary care {@link PatientProviders} assigned to the patient

    GET
    http://host:port/VeteranAppointmentRequestService/v4/provider-service/patient/{assigning-authority}/{user-id}/providers/primarycare

Returns Mental Health {@link PatientProviders} matching the filter criteria

    GET
    http://host:port/VeteranAppointmentRequestService/v4/provider-service/patient/{assigning-authority}/{user-id}/providers/mentalhealth


### Load the data into Mongo
#### Populate sites supporting VAR in Mongo
1. Go to the project directory on a terminal
2. cd data
3. run:

    ./install-sites-supporting-var-collection.sh sites-supporting-var.json

#### Populate type of care options for community care request in Mongo
1. Go to the project directory on a terminal
2. cd data
3. run:

    ./install-cc-typeOfCares-collection.sh community-care-type-of-cares.json

